*! version 4.0
* 29 June 2021
* NIDS-CRAM
* This do-file contains the code to create deflators to deflate NIDS-CRAM Wave 1 financial data. Deflated values can be generated by multiplying the relevant 
* financial data variable by the deflator generated by this do-file.

*=====================================================================================================================================
/*

THIS DO FILE CREATES DEFLATORS FOR USE WITH THE NIDS-CRAM DATASET.
BASE MONTH IS FEB 2020 AND INTERVIEW DATES ARE TAKEN FROM THE HOUSEHOLD QUESTIONNAIRE. MISSING INTERVIEW MONTHS ARE IMPUTED TO THE MODAL MONTH FOR THE RELEVANT WAVE.

PRICE INDICES ARE FROM THE NATIONAL HEADLINE CPI INDEX PUBLISHED BY STATS SA, AVAILABLE HERE:
http://www.statssa.gov.za/publications/P0141/CPIHistory.pdf??
*/
*=====================================================================================================================================

* GLOBALS FOR DATA FILES AND VERSION SUFFIXES
global NC1Data "C:\Users\\Dropbox\Data\NIDS\Data\c1"				//File path to where input data is located. Change this path according to where your data folder is located on your computer.
global NC1VerIN "Wave1_Anon_V3.0.0"

global DataOUT "C:\Users\\Dropbox\Data\NIDS\Data\c1_d"			//File path to where you want to save subsequent data files. 
global VersionOUT "merged"

global temp "C:\Users\Desktop"									//Tempfile to hold all the working datasets, all working datasets will be deleted from this folder at the completion of the do file execution.
																		
version 16.0													//Version of Stata being used.

clear
cap clear matrix
set more off

scalar base=115.2 												//Set scalar to base month, currently Feb 2020

*=====================================================================================================================================


* NIDS-CRAM QUESTIONNAIRE
use "$NC1Data\NIDS-CRAM_$NC1VerIN.dta", clear

cap drop w1_nc_deflator
gen w1_nc_deflator=.
replace w1_nc_deflator=base/115.0       // April 2020 

lab var w1_nc_deflator "NIDS-CRAM W1 deflator"

save "$NC1Data\NIDS-CRAM_$VersionOUT.dta", replace

*=====================================================================================================================================

* end of do file


